/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.awt.Rectangle;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.HyphenationProps;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.TextState;
import org.apache.fop.layout.hyphenation.Hyphenation;
import org.apache.fop.layout.hyphenation.Hyphenator;
import org.apache.fop.layout.inline.InlineArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.PageNumberInlineArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.Renderer;

public class LineArea
extends Area {
    protected int lineHeight;
    protected int halfLeading;
    protected int nominalFontSize;
    protected int nominalGlyphHeight;
    protected int allocationHeight;
    protected int startIndent;
    protected int endIndent;
    private int placementOffset;
    private FontState currentFontState;
    private float red;
    private float green;
    private float blue;
    private int wrapOption;
    private int whiteSpaceCollapse;
    int vAlign;
    HyphenationProps hyphProps;
    protected int finalWidth = 0;
    protected int embeddedLinkStart = 0;
    protected static final int NOTHING = 0;
    protected static final int WHITESPACE = 1;
    protected static final int TEXT = 2;
    protected static final int MULTIBYTECHAR = 3;
    protected int prev = 0;
    protected int spaceWidth = 0;
    protected ArrayList pendingAreas = new ArrayList();
    public int pendingWidth = 0;
    protected boolean prevUlState = false;
    protected boolean prevOlState = false;
    protected boolean prevLTState = false;

    public LineArea(FontState fontState, int lineHeight, int halfLeading, int allocationWidth, int startIndent, int endIndent, LineArea prevLineArea) {
        super(fontState);
        this.currentFontState = fontState;
        this.lineHeight = lineHeight;
        this.nominalFontSize = fontState.getFontSize();
        this.nominalGlyphHeight = fontState.getAscender() - fontState.getDescender();
        this.placementOffset = fontState.getAscender();
        this.contentRectangleWidth = allocationWidth - startIndent - endIndent;
        this.fontState = fontState;
        this.allocationHeight = this.nominalGlyphHeight;
        this.halfLeading = this.lineHeight - this.allocationHeight;
        this.startIndent = startIndent;
        this.endIndent = endIndent;
        if (prevLineArea != null) {
            boolean eatMoreSpace = true;
            this.pendingWidth = prevLineArea.pendingWidth;
            int i = 0;
            while (i < prevLineArea.pendingAreas.size()) {
                Object b = prevLineArea.pendingAreas.get(i);
                if (eatMoreSpace) {
                    if (b instanceof InlineSpace) {
                        InlineSpace is = (InlineSpace)b;
                        if (is.isEatable()) {
                            this.pendingWidth -= is.getSize();
                        } else {
                            eatMoreSpace = false;
                            this.pendingAreas.add(b);
                        }
                    } else {
                        eatMoreSpace = false;
                        this.pendingAreas.add(b);
                    }
                } else {
                    this.pendingAreas.add(b);
                }
                ++i;
            }
            prevLineArea.pendingWidth = 0;
            prevLineArea.pendingAreas = null;
        }
    }

    public int addCharacter(char data, LinkSet ls, boolean ul) {
        WordArea ia = null;
        int remainingWidth = this.getRemainingWidth();
        int width = this.getCharWidth(data);
        if (width > remainingWidth) {
            return 1;
        }
        if (Character.isSpaceChar(data) && this.whiteSpaceCollapse == 120) {
            return 0;
        }
        ia = new WordArea(this.currentFontState, this.red, this.green, this.blue, new Character(data).toString(), width);
        ia.setYOffset(this.placementOffset);
        ia.setUnderlined(ul);
        this.pendingAreas.add(ia);
        if (Character.isSpaceChar(data)) {
            this.spaceWidth = width;
            this.prev = 1;
        } else {
            this.pendingWidth += width;
            this.prev = 2;
        }
        return 0;
    }

    public void addInlineArea(InlineArea box, LinkSet ls) {
        this.addPending();
        this.addChild(box);
        if (ls != null) {
            Rectangle lr = new Rectangle(this.finalWidth, 0, box.getContentWidth(), box.getContentHeight());
            ls.addRect(lr, this, box);
        }
        this.prev = 2;
        this.finalWidth += box.getContentWidth();
    }

    public void addInlineSpace(InlineSpace is, int spaceWidth) {
        this.addChild(is);
        this.finalWidth += spaceWidth;
    }

    public void addLeader(int leaderPattern, int leaderLengthMinimum, int leaderLengthOptimum, int leaderLengthMaximum, int ruleStyle, int ruleThickness, int leaderPatternWidth, int leaderAlignment) {
        if (leaderLengthMinimum > leaderLengthOptimum || leaderLengthOptimum > leaderLengthMaximum) {
            MessageHandler.errorln("leader sizes wrong");
            return;
        }
        if (leaderLengthOptimum > this.getRemainingWidth()) {
            MessageHandler.errorln("leader width assertion failed");
            return;
        }
        this.addPending();
        this.children.add(new Leader(leaderPattern, leaderLengthMinimum, leaderLengthOptimum, leaderLengthMaximum, ruleStyle, ruleThickness, leaderPatternWidth, leaderAlignment, this.fontState, this.red, this.green, this.blue, this.placementOffset, this.getCurrentXPosition()));
        this.finalWidth += leaderLengthOptimum;
    }

    public int addPageNumberCitation(String refid, LinkSet ls) {
        int width = 3 * this.getCharWidth(' ');
        PageNumberInlineArea pia = new PageNumberInlineArea(this.currentFontState, this.red, this.green, this.blue, refid, width);
        pia.setYOffset(this.placementOffset);
        this.pendingAreas.add(pia);
        this.pendingWidth += width;
        this.prev = 2;
        return -1;
    }

    public void addPending() {
        if (this.spaceWidth > 0) {
            this.addChild(new InlineSpace(this.spaceWidth));
            this.finalWidth += this.spaceWidth;
            this.spaceWidth = 0;
        }
        int i = 0;
        while (i < this.pendingAreas.size()) {
            Box box = (Box)this.pendingAreas.get(i);
            this.addChild(box);
            ++i;
        }
        this.finalWidth += this.pendingWidth;
        this.pendingWidth = 0;
        this.pendingAreas = new ArrayList();
    }

    private void addSpacedWord(String word, LinkSet ls, int startw, int spacew, TextState textState, boolean addToPending) {
        StringTokenizer st = new StringTokenizer(word, "\u00a0\u202f\u3000\ufeff", true);
        while (st.hasMoreTokens()) {
            String currentWord = st.nextToken();
            if (currentWord.length() == 1 && this.isNBSP(currentWord.charAt(0))) {
                int spaceWidth = this.getCharWidth(currentWord.charAt(0));
                if (spaceWidth <= 0) continue;
                InlineSpace is = new InlineSpace(spaceWidth);
                startw += spaceWidth;
                if (this.prevUlState) {
                    is.setUnderlined(textState.getUnderlined());
                }
                if (this.prevOlState) {
                    is.setOverlined(textState.getOverlined());
                }
                if (this.prevLTState) {
                    is.setLineThrough(textState.getLineThrough());
                }
                if (addToPending) {
                    this.pendingAreas.add(is);
                    this.pendingWidth += spaceWidth;
                    continue;
                }
                this.addChild(is);
                continue;
            }
            int wordWidth = this.getWordWidth(currentWord);
            WordArea ia = new WordArea(this.currentFontState, this.red, this.green, this.blue, currentWord, wordWidth);
            ia.setYOffset(this.placementOffset);
            ia.setUnderlined(textState.getUnderlined());
            this.prevUlState = textState.getUnderlined();
            ia.setOverlined(textState.getOverlined());
            this.prevOlState = textState.getOverlined();
            ia.setLineThrough(textState.getLineThrough());
            this.prevLTState = textState.getLineThrough();
            ia.setVerticalAlign(this.vAlign);
            if (addToPending) {
                this.pendingAreas.add(ia);
                this.pendingWidth += wordWidth;
            } else {
                this.addChild(ia);
            }
            if (ls != null) {
                Rectangle lr = new Rectangle(startw, spacew, ia.getContentWidth(), this.fontState.getFontSize());
                ls.addRect(lr, this, ia);
            }
            startw += wordWidth;
        }
    }

    public int addText(char[] data, int start, int end, LinkSet ls, TextState textState) {
        if (start == -1) {
            return -1;
        }
        boolean overrun = false;
        int wordStart = start;
        int wordLength = 0;
        int wordWidth = 0;
        int whitespaceWidth = this.getCharWidth(' ');
        boolean isText = false;
        boolean isMultiByteChar = false;
        int i = start;
        while (i < end) {
            int charWidth;
            char c = data[i];
            if (!this.isSpace(c) && c != '\n' && c != '\r' && c != '\t' && c != '\u2028') {
                charWidth = this.getCharWidth(c);
                isText = true;
                boolean bl = isMultiByteChar = c > '\u007f';
                if (charWidth <= 0 && c != '\u200b' && c != '\ufeff') {
                    charWidth = whitespaceWidth;
                }
            } else {
                charWidth = c == '\n' || c == '\r' || c == '\t' ? whitespaceWidth : this.getCharWidth(c);
                isText = false;
                isMultiByteChar = false;
                if (this.prev == 1) {
                    if (this.whiteSpaceCollapse == 36) {
                        if (this.isSpace(c)) {
                            this.spaceWidth += this.getCharWidth(c);
                        } else {
                            if (c == '\n' || c == '\u2028') {
                                if (this.spaceWidth > 0) {
                                    InlineSpace is = new InlineSpace(this.spaceWidth);
                                    is.setUnderlined(textState.getUnderlined());
                                    is.setOverlined(textState.getOverlined());
                                    is.setLineThrough(textState.getLineThrough());
                                    this.addChild(is);
                                    this.finalWidth += this.spaceWidth;
                                    this.spaceWidth = 0;
                                }
                                return i + 1;
                            }
                            if (c == '\t') {
                                this.spaceWidth += 8 * whitespaceWidth;
                            }
                        }
                    } else if (c == '\u2028') {
                        if (this.spaceWidth > 0) {
                            InlineSpace is = new InlineSpace(this.spaceWidth);
                            is.setUnderlined(textState.getUnderlined());
                            is.setOverlined(textState.getOverlined());
                            is.setLineThrough(textState.getLineThrough());
                            this.addChild(is);
                            this.finalWidth += this.spaceWidth;
                            this.spaceWidth = 0;
                        }
                        return i + 1;
                    }
                } else if (this.prev == 2 || this.prev == 3) {
                    if (this.spaceWidth > 0) {
                        InlineSpace is = new InlineSpace(this.spaceWidth);
                        if (this.prevUlState) {
                            is.setUnderlined(textState.getUnderlined());
                        }
                        if (this.prevOlState) {
                            is.setOverlined(textState.getOverlined());
                        }
                        if (this.prevLTState) {
                            is.setLineThrough(textState.getLineThrough());
                        }
                        this.addChild(is);
                        this.finalWidth += this.spaceWidth;
                        this.spaceWidth = 0;
                    }
                    int j = 0;
                    while (j < this.pendingAreas.size()) {
                        Box box = (Box)this.pendingAreas.get(j);
                        if (box instanceof InlineArea && ls != null) {
                            Rectangle lr = new Rectangle(this.finalWidth, 0, ((InlineArea)box).getContentWidth(), this.fontState.getFontSize());
                            ls.addRect(lr, this, (InlineArea)box);
                        }
                        this.addChild(box);
                        ++j;
                    }
                    this.finalWidth += this.pendingWidth;
                    this.pendingWidth = 0;
                    this.pendingAreas = new ArrayList();
                    if (wordLength > 0) {
                        this.addSpacedWord(new String(data, wordStart, wordLength), ls, this.finalWidth, 0, textState, false);
                        this.finalWidth += wordWidth;
                        wordWidth = 0;
                    }
                    this.prev = 1;
                    this.embeddedLinkStart = 0;
                    this.spaceWidth = this.getCharWidth(c);
                    if (this.whiteSpaceCollapse == 36) {
                        if (c == '\n' || c == '\u2028') {
                            return i + 1;
                        }
                        if (c == '\t') {
                            this.spaceWidth = whitespaceWidth;
                        }
                    } else if (c == '\u2028') {
                        return i + 1;
                    }
                } else if (this.whiteSpaceCollapse == 36) {
                    if (this.isSpace(c)) {
                        this.prev = 1;
                        this.spaceWidth = this.getCharWidth(c);
                    } else {
                        if (c == '\n') {
                            InlineSpace is = new InlineSpace(this.spaceWidth);
                            this.addChild(is);
                            return i + 1;
                        }
                        if (c == '\t') {
                            this.prev = 1;
                            this.spaceWidth = 8 * whitespaceWidth;
                        }
                    }
                } else {
                    ++wordStart;
                }
            }
            if (isText) {
                int curr;
                int n = curr = isMultiByteChar ? 3 : 2;
                if (this.prev == 1) {
                    wordWidth = charWidth;
                    if (this.finalWidth + this.spaceWidth + wordWidth > this.getContentWidth()) {
                        if (overrun) {
                            MessageHandler.log("area contents overflows area");
                        }
                        if (this.wrapOption == 126) {
                            return i;
                        }
                    }
                    this.prev = curr;
                    wordStart = i;
                    wordLength = 1;
                } else if (this.prev == 2 || this.prev == 3) {
                    if (this.prev == 2 && curr == 2 || !this.canBreakMidWord()) {
                        ++wordLength;
                        wordWidth += charWidth;
                    } else {
                        InlineSpace is = new InlineSpace(this.spaceWidth);
                        if (this.prevUlState) {
                            is.setUnderlined(textState.getUnderlined());
                        }
                        if (this.prevOlState) {
                            is.setOverlined(textState.getOverlined());
                        }
                        if (this.prevLTState) {
                            is.setLineThrough(textState.getLineThrough());
                        }
                        this.addChild(is);
                        this.finalWidth += this.spaceWidth;
                        this.spaceWidth = 0;
                        int j = 0;
                        while (j < this.pendingAreas.size()) {
                            Box box = (Box)this.pendingAreas.get(j);
                            if (box instanceof InlineArea && ls != null) {
                                Rectangle lr = new Rectangle(this.finalWidth, 0, ((InlineArea)box).getContentWidth(), this.fontState.getFontSize());
                                ls.addRect(lr, this, (InlineArea)box);
                            }
                            this.addChild(box);
                            ++j;
                        }
                        this.finalWidth += this.pendingWidth;
                        this.pendingWidth = 0;
                        this.pendingAreas = new ArrayList();
                        if (wordLength > 0) {
                            this.addSpacedWord(new String(data, wordStart, wordLength), ls, this.finalWidth, 0, textState, false);
                            this.finalWidth += wordWidth;
                        }
                        this.spaceWidth = 0;
                        wordStart = i;
                        wordLength = 1;
                        wordWidth = charWidth;
                    }
                    this.prev = curr;
                } else {
                    this.prev = curr;
                    wordStart = i;
                    wordLength = 1;
                    wordWidth = charWidth;
                }
                if (this.finalWidth + this.spaceWidth + this.pendingWidth + wordWidth > this.getContentWidth() && this.wrapOption == 126) {
                    if (this.hyphProps.hyphenate == 120) {
                        int ret = wordStart;
                        ret = this.doHyphenation(data, i, wordStart, this.getContentWidth() - (this.finalWidth + this.spaceWidth + this.pendingWidth), this.finalWidth + this.spaceWidth + this.embeddedLinkStart, ls, textState);
                        if (ret == wordStart && wordStart == start && this.finalWidth == 0) {
                            MessageHandler.log("area contents overflows area");
                            this.addSpacedWord(new String(data, wordStart, wordLength - 1), ls, this.embeddedLinkStart, this.spaceWidth, textState, false);
                            this.finalWidth += wordWidth;
                            wordWidth = 0;
                            ret = i;
                        }
                        return ret;
                    }
                    if (wordStart == start) {
                        overrun = true;
                        if (this.finalWidth > 0) {
                            return wordStart;
                        }
                    } else {
                        return wordStart;
                    }
                }
            }
            ++i;
        }
        if (this.prev == 2 || this.prev == 3) {
            if (this.spaceWidth > 0) {
                InlineSpace pis = new InlineSpace(this.spaceWidth);
                pis.setEatable(true);
                if (this.prevUlState) {
                    pis.setUnderlined(textState.getUnderlined());
                }
                if (this.prevOlState) {
                    pis.setOverlined(textState.getOverlined());
                }
                if (this.prevLTState) {
                    pis.setLineThrough(textState.getLineThrough());
                }
                this.pendingAreas.add(pis);
                this.pendingWidth += this.spaceWidth;
                this.spaceWidth = 0;
            }
            this.addSpacedWord(new String(data, wordStart, wordLength), ls, this.finalWidth + this.pendingWidth, this.spaceWidth, textState, true);
            this.embeddedLinkStart += wordWidth;
            wordWidth = 0;
        }
        if (overrun) {
            MessageHandler.log("area contents overflows area");
        }
        return -1;
    }

    private void addWord(StringBuffer wordBuf, int startw, LinkSet ls, TextState textState) {
        if (this.spaceWidth > 0) {
            InlineSpace is = new InlineSpace(this.spaceWidth);
            if (this.prevUlState) {
                is.setUnderlined(textState.getUnderlined());
            }
            if (this.prevOlState) {
                is.setOverlined(textState.getOverlined());
            }
            if (this.prevLTState) {
                is.setLineThrough(textState.getLineThrough());
            }
            this.addChild(is);
            this.finalWidth += this.spaceWidth;
            this.spaceWidth = 0;
        }
        int i = 0;
        while (i < this.pendingAreas.size()) {
            Box box = (Box)this.pendingAreas.get(i);
            if (box instanceof InlineArea && ls != null) {
                Rectangle lr = new Rectangle(this.finalWidth, 0, ((InlineArea)box).getContentWidth(), this.fontState.getFontSize());
                ls.addRect(lr, this, (InlineArea)box);
            }
            this.addChild(box);
            ++i;
        }
        this.finalWidth += this.pendingWidth;
        this.pendingWidth = 0;
        this.pendingAreas = new ArrayList();
        String word = wordBuf != null ? wordBuf.toString() : "";
        int wordWidth = this.getWordWidth(word);
        WordArea hia = new WordArea(this.currentFontState, this.red, this.green, this.blue, word, wordWidth);
        hia.setYOffset(this.placementOffset);
        hia.setUnderlined(textState.getUnderlined());
        this.prevUlState = textState.getUnderlined();
        hia.setOverlined(textState.getOverlined());
        this.prevOlState = textState.getOverlined();
        hia.setLineThrough(textState.getLineThrough());
        this.prevLTState = textState.getLineThrough();
        hia.setVerticalAlign(this.vAlign);
        this.addChild(hia);
        if (ls != null) {
            Rectangle lr = new Rectangle(startw, 0, hia.getContentWidth(), this.fontState.getFontSize());
            ls.addRect(lr, this, hia);
        }
        this.finalWidth += wordWidth;
    }

    public void align(int type) {
        int padding = 0;
        switch (type) {
            case 106: {
                padding = this.getContentWidth() - this.finalWidth;
                this.endIndent += padding;
                int i = 0;
                while (i < this.children.size()) {
                    Object o = this.children.get(i);
                    if (o instanceof Leader) {
                        Leader leader = (Leader)o;
                        leader.expand(leader.leaderLengthOptimum);
                    }
                    ++i;
                }
                break;
            }
            case 30: {
                padding = this.getContentWidth() - this.finalWidth;
                this.startIndent += padding;
                int i = 0;
                while (i < this.children.size()) {
                    Object o = this.children.get(i);
                    if (o instanceof Leader) {
                        Leader leader = (Leader)o;
                        leader.expand(leader.leaderLengthOptimum);
                    }
                    ++i;
                }
                break;
            }
            case 16: {
                padding = (this.getContentWidth() - this.finalWidth) / 2;
                this.startIndent += padding;
                this.endIndent += padding;
                int i = 0;
                while (i < this.children.size()) {
                    Object o = this.children.get(i);
                    if (o instanceof Leader) {
                        Leader leader = (Leader)o;
                        leader.expand(leader.leaderLengthOptimum);
                    }
                    ++i;
                }
                break;
            }
            case 54: {
                InlineSpace space;
                Object o;
                int leaderCount = 0;
                int spaceCount = 0;
                int i = 0;
                while (i < this.children.size()) {
                    o = this.children.get(i);
                    if (o instanceof InlineSpace) {
                        space = (InlineSpace)o;
                        if (space.getResizeable()) {
                            ++spaceCount;
                        }
                    } else if (o instanceof Leader) {
                        ++leaderCount;
                    }
                    ++i;
                }
                padding = this.getContentWidth() - this.finalWidth;
                if (padding <= 0) break;
                if (leaderCount > 0) {
                    int offset = 0;
                    int i2 = 0;
                    while (i2 < this.children.size()) {
                        Object o2 = this.children.get(i2);
                        if (o2 instanceof Leader) {
                            Leader leader = (Leader)o2;
                            int leaderExpansionMaximum = leader.leaderLengthMaximum - leader.leaderLengthOptimum;
                            if (leaderExpansionMaximum < padding) {
                                leader.expand(leader.leaderLengthMaximum);
                                padding -= leaderExpansionMaximum;
                                offset += leaderExpansionMaximum;
                            } else {
                                leader.expand(leader.leaderLengthOptimum + padding);
                                padding = 0;
                                offset += padding;
                            }
                        } else if (o2 instanceof InlineArea) {
                            ((InlineArea)o2).setXOffset(((InlineArea)o2).getXOffset() + offset);
                        }
                        ++i2;
                    }
                }
                padding = spaceCount > 0 && padding > 0 ? (padding /= spaceCount) : 0;
                spaceCount = 0;
                i = 0;
                while (i < this.children.size()) {
                    o = this.children.get(i);
                    if (o instanceof InlineSpace) {
                        space = (InlineSpace)o;
                        if (space.getResizeable()) {
                            space.setSize(space.getSize() + padding);
                            ++spaceCount;
                        }
                    } else if (o instanceof InlineArea) {
                        ((InlineArea)o).setXOffset(((InlineArea)o).getXOffset() + i * padding);
                    }
                    ++i;
                }
                break;
            }
            default: {
                MessageHandler.errorln("bad align: " + type);
            }
        }
    }

    private InlineArea buildSimpleLeader(char c, int leaderLength) {
        int width = this.getCharWidth(c);
        if (width == 0) {
            MessageHandler.errorln("char " + c + " has width 0. Using width 100 instead.");
            width = 100;
        }
        int factor = (int)Math.floor(leaderLength / width);
        char[] leaderChars = new char[factor];
        int i = 0;
        while (i < factor) {
            leaderChars[i] = c;
            ++i;
        }
        WordArea leaderPatternArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, new String(leaderChars), leaderLength);
        leaderPatternArea.setYOffset(this.placementOffset);
        return leaderPatternArea;
    }

    private boolean canBreakMidWord() {
        String lang;
        boolean ret = false;
        if (this.hyphProps != null && this.hyphProps.language != null && !this.hyphProps.language.equals("NONE") && ("zh".equals(lang = this.hyphProps.language.toLowerCase()) || "ja".equals(lang) || "ko".equals(lang) || "vi".equals(lang))) {
            ret = true;
        }
        return ret;
    }

    public void changeColor(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void changeFont(FontState fontState) {
        this.currentFontState = fontState;
    }

    public void changeHyphenation(HyphenationProps hyphProps) {
        this.hyphProps = hyphProps;
    }

    public void changeVerticalAlign(int vAlign) {
        this.vAlign = vAlign;
    }

    public void changeWhiteSpaceCollapse(int whiteSpaceCollapse) {
        this.whiteSpaceCollapse = whiteSpaceCollapse;
    }

    public void changeWrapOption(int wrapOption) {
        this.wrapOption = wrapOption;
    }

    public int doHyphenation(char[] characters, int position, int wordStart, int remainingWidth, int startw, LinkSet ls, TextState textState) {
        Hyphenation hyph;
        char inwordPunctuation;
        String wordToHyphenate;
        if (this.hyphProps.language.equalsIgnoreCase("none")) {
            MessageHandler.errorln("if property 'hyphenate' is used, a language must be specified");
            return wordStart;
        }
        StringBuffer remainingString = new StringBuffer();
        StringBuffer preString = null;
        int hyphCharWidth = this.getCharWidth(this.hyphProps.hyphenationChar);
        remainingWidth -= hyphCharWidth;
        if (characters[wordStart] == '\"' || characters[wordStart] == '\'') {
            remainingString.append(characters[wordStart]);
            wordToHyphenate = this.getHyphenationWord(characters, wordStart + 1);
        } else {
            wordToHyphenate = this.getHyphenationWord(characters, wordStart);
        }
        if (this.getWordWidth(wordToHyphenate) < remainingWidth && ((inwordPunctuation = characters[wordStart + remainingString.length() + wordToHyphenate.length()]) == '-' || inwordPunctuation == '/')) {
            preString = new StringBuffer(wordToHyphenate);
            preString = preString.append(inwordPunctuation);
            wordToHyphenate = this.getHyphenationWord(characters, wordStart + remainingString.length() + wordToHyphenate.length() + 1);
            remainingWidth -= this.getWordWidth(wordToHyphenate) + this.getCharWidth(inwordPunctuation);
        }
        if ((hyph = Hyphenator.hyphenate(this.hyphProps.language, this.hyphProps.country, wordToHyphenate, this.hyphProps.hyphenationRemainCharacterCount, this.hyphProps.hyphenationPushCharacterCount)) == null && preString == null) {
            return wordStart;
        }
        if (hyph == null && preString != null) {
            remainingString.append((Object)preString);
            this.addWord(remainingString, startw, ls, textState);
            return wordStart + remainingString.length();
        }
        if (hyph != null && preString == null) {
            int index = this.getFinalHyphenationPoint(hyph, remainingWidth);
            if (index != -1) {
                remainingString.append(hyph.getPreHyphenText(index));
                remainingString.append(this.hyphProps.hyphenationChar);
                this.addWord(remainingString, startw, ls, textState);
                return wordStart + remainingString.length() - 1;
            }
        } else if (hyph != null && preString != null) {
            int index = this.getFinalHyphenationPoint(hyph, remainingWidth);
            if (index != -1) {
                remainingString.append((Object)preString.append(hyph.getPreHyphenText(index)));
                remainingString.append(this.hyphProps.hyphenationChar);
                this.addWord(remainingString, startw, ls, textState);
                return wordStart + remainingString.length() - 1;
            }
            remainingString.append((Object)preString);
            this.addWord(remainingString, startw, ls, textState);
            return wordStart + remainingString.length();
        }
        return wordStart;
    }

    private int getCharWidth(char c) {
        if (c == '\n' || c == '\r' || c == '\t') {
            return this.getCharWidth(' ');
        }
        char mappedChar = this.currentFontState.mapChar(c);
        if (mappedChar == '#' || mappedChar == '\u0000') {
            if (c == '#') {
                return this.currentFontState.width(mappedChar);
            }
            if (c == ' ') {
                return this.getEmWidth();
            }
            if (c == '\u00a0') {
                return this.getCharWidth(' ');
            }
            if (c == '\u2000') {
                return this.getEnWidth();
            }
            if (c == '\u2001') {
                return this.getEmWidth();
            }
            if (c == '\u2002') {
                return this.getEnWidth();
            }
            if (c == '\u2003') {
                return this.getEmWidth();
            }
            if (c == '\u2004') {
                return this.getEmWidth() / 3;
            }
            if (c == '\u2005') {
                return this.getEmWidth() / 4;
            }
            if (c == '\u2006') {
                return this.getEmWidth() / 6;
            }
            if (c == '\u2007') {
                return this.getCharWidth(' ');
            }
            if (c == '\u2008') {
                return this.getCharWidth('.');
            }
            if (c == '\u2009') {
                return this.getEmWidth() / 5;
            }
            if (c == '\u200a') {
                return this.getEmWidth() / 10;
            }
            if (c == '\u200b') {
                return 1;
            }
            if (c == '\u202f') {
                return this.getCharWidth(' ') / 2;
            }
            if (c == '\u3000') {
                return this.getCharWidth(' ') * 2;
            }
            if (c == '\u3000') {
                return this.getCharWidth(' ') * 2;
            }
            return this.currentFontState.width(mappedChar);
        }
        return this.currentFontState.width(mappedChar);
    }

    private int getCurrentXPosition() {
        return this.finalWidth + this.spaceWidth + this.startIndent + this.pendingWidth;
    }

    private final int getEmWidth() {
        char mappedChar = this.currentFontState.mapChar('m');
        if (mappedChar == '#') {
            return 500 * this.currentFontState.getFontSize();
        }
        return this.currentFontState.width(mappedChar);
    }

    private final int getEnWidth() {
        char mappedChar = this.currentFontState.mapChar('n');
        if (mappedChar != '#') {
            return this.getEmWidth() * 9 / 10;
        }
        return this.currentFontState.width(mappedChar);
    }

    public int getEndIndent() {
        return this.endIndent;
    }

    private int getFinalHyphenationPoint(Hyphenation hyph, int remainingWidth) {
        int[] hyphenationPoints = hyph.getHyphenationPoints();
        int numberOfHyphenationPoints = hyphenationPoints.length;
        int index = -1;
        String wordBegin = "";
        boolean wordBeginWidth = false;
        int i = 0;
        while (i < numberOfHyphenationPoints) {
            wordBegin = hyph.getPreHyphenText(i);
            if (this.getWordWidth(wordBegin) > remainingWidth) break;
            index = i++;
        }
        return index;
    }

    public int getHeight() {
        return this.allocationHeight;
    }

    private String getHyphenationWord(char[] characters, int wordStart) {
        boolean wordendFound = false;
        int counter = 0;
        char[] newWord = new char[characters.length];
        while (!wordendFound && wordStart + counter < characters.length) {
            char tk = characters[wordStart + counter];
            if (Character.isLetter(tk)) {
                newWord[counter] = tk;
                ++counter;
                continue;
            }
            wordendFound = true;
        }
        return new String(newWord, 0, counter);
    }

    public int getPlacementOffset() {
        return this.placementOffset;
    }

    public int getRemainingWidth() {
        return this.getContentWidth() + this.startIndent - this.getCurrentXPosition();
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    private int getWordWidth(String word) {
        if (word == null) {
            return 0;
        }
        int wordLength = word.length();
        int width = 0;
        char[] characters = new char[wordLength];
        word.getChars(0, wordLength, characters, 0);
        int i = 0;
        while (i < wordLength) {
            width += this.getCharWidth(characters[i]);
            ++i;
        }
        return width;
    }

    private boolean isAnySpace(char c) {
        boolean ret = this.isSpace(c) || this.isNBSP(c);
        return ret;
    }

    public boolean isEmpty() {
        return (this.pendingAreas.size() > 0 || this.children.size() > 0) ^ true;
    }

    private boolean isNBSP(char c) {
        return c == '\u00a0' || c == '\u202f' || c == '\u3000' || c == '\ufeff';
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\u2000' || c == '\u2001' || c == '\u2002' || c == '\u2003' || c == '\u2004' || c == '\u2005' || c == '\u2006' || c == '\u2007' || c == '\u2008' || c == '\u2009' || c == '\u200a' || c == '\u200b';
    }

    public void render(Renderer renderer) {
        renderer.renderLineArea(this);
    }

    public void setLinkSet(LinkSet ls) {
    }

    public void verticalAlign() {
        int superHeight = -this.placementOffset;
        int maxHeight = this.allocationHeight;
        int i = 0;
        while (i < this.children.size()) {
            Box b = (Box)this.children.get(i);
            if (b instanceof InlineArea) {
                int fh;
                int vert;
                InlineArea ia = (InlineArea)b;
                if (ia instanceof WordArea) {
                    ia.setYOffset(this.placementOffset);
                }
                if (ia.getHeight() > maxHeight) {
                    maxHeight = ia.getHeight();
                }
                if ((vert = ia.getVerticalAlign()) == 109) {
                    fh = this.fontState.getAscender();
                    ia.setYOffset((int)((double)this.placementOffset - (double)(2 * fh) / 3.0));
                } else if (vert == 108) {
                    fh = this.fontState.getAscender();
                    ia.setYOffset((int)((double)this.placementOffset + (double)(2 * fh) / 3.0));
                }
            }
            ++i;
        }
        this.allocationHeight = maxHeight;
    }

    public class Leader {
        int leaderPattern;
        int leaderLengthMinimum;
        int leaderLengthOptimum;
        int leaderLengthMaximum;
        int ruleStyle;
        int ruleThickness;
        int leaderPatternWidth;
        int leaderAlignment;
        FontState fontState;
        float red;
        float green;
        float blue;
        int placementOffset;
        int position;

        Leader(int leaderPattern, int leaderLengthMinimum, int leaderLengthOptimum, int leaderLengthMaximum, int ruleStyle, int ruleThickness, int leaderPatternWidth, int leaderAlignment, FontState fontState, float red, float green, float blue, int placementOffset, int position) {
            this.leaderPattern = leaderPattern;
            this.leaderLengthMinimum = leaderLengthMinimum;
            this.leaderLengthOptimum = leaderLengthOptimum;
            this.leaderLengthMaximum = leaderLengthMaximum;
            this.ruleStyle = ruleStyle;
            this.ruleThickness = ruleThickness;
            this.leaderPatternWidth = leaderPatternWidth;
            this.leaderAlignment = leaderAlignment;
            this.fontState = fontState;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.placementOffset = placementOffset;
            this.position = position;
        }

        void expand(int leaderLength) {
            char dot = '.';
            int dotWidth = LineArea.this.getCharWidth(dot);
            char space = ' ';
            int spaceWidth = LineArea.this.getCharWidth(space);
            int idx = LineArea.this.children.indexOf(this);
            ((AbstractCollection)LineArea.this.children).remove(this);
            switch (this.leaderPattern) {
                case 105: {
                    InlineSpace spaceArea = new InlineSpace(leaderLength, false);
                    LineArea.this.children.add(idx, spaceArea);
                    break;
                }
                case 100: {
                    LeaderArea leaderArea = new LeaderArea(this.fontState, this.red, this.green, this.blue, "", leaderLength, this.leaderPattern, this.ruleThickness, this.ruleStyle);
                    leaderArea.setYOffset(this.placementOffset);
                    LineArea.this.children.add(idx, leaderArea);
                    break;
                }
                case 26: {
                    int nextRepeatedLeaderPatternCycle;
                    int spaceBeforeLeader;
                    if (this.leaderPatternWidth < dotWidth) {
                        this.leaderPatternWidth = 0;
                    }
                    if (this.leaderPatternWidth == 0) {
                        int nextRepeatedLeaderPatternCycle2;
                        int spaceBeforeLeader2;
                        if (dotWidth == 0) {
                            MessageHandler.errorln("char " + dot + " has width 0. Using width 100 instead.");
                            dotWidth = 100;
                        }
                        if (this.leaderAlignment == 87 && (spaceBeforeLeader2 = dotWidth * (nextRepeatedLeaderPatternCycle2 = (int)Math.ceil((double)this.position / (double)dotWidth)) - this.position) > 0) {
                            LineArea.this.children.add(idx, new InlineSpace(spaceBeforeLeader2, false));
                            ++idx;
                            leaderLength -= spaceBeforeLeader2;
                        }
                        int factor = (int)Math.floor(leaderLength / dotWidth);
                        char[] leaderChars = new char[factor];
                        int i = 0;
                        while (i < factor) {
                            leaderChars[i] = dot;
                            ++i;
                        }
                        WordArea leaderPatternArea = new WordArea(LineArea.this.currentFontState, this.red, this.green, this.blue, new String(leaderChars), leaderLength);
                        leaderPatternArea.setYOffset(this.placementOffset);
                        LineArea.this.children.add(idx, leaderPatternArea);
                        break;
                    }
                    if (this.leaderAlignment == 87 && (spaceBeforeLeader = this.leaderPatternWidth * (nextRepeatedLeaderPatternCycle = (int)Math.ceil((double)this.position / (double)this.leaderPatternWidth)) - this.position) > 0) {
                        LineArea.this.children.add(idx, new InlineSpace(spaceBeforeLeader, false));
                        ++idx;
                        leaderLength -= spaceBeforeLeader;
                    }
                    int dotsFactor = (int)Math.floor((double)leaderLength / (double)this.leaderPatternWidth);
                    int i = 0;
                    while (i < dotsFactor) {
                        InlineSpace spaceBetweenDots = new InlineSpace(this.leaderPatternWidth - dotWidth, false);
                        WordArea leaderPatternArea = new WordArea(this.fontState, this.red, this.green, this.blue, new String("."), dotWidth);
                        leaderPatternArea.setYOffset(this.placementOffset);
                        LineArea.this.children.add(idx, leaderPatternArea);
                        LineArea.this.children.add(++idx, spaceBetweenDots);
                        ++idx;
                        ++i;
                    }
                    LineArea.this.children.add(idx, new InlineSpace(leaderLength - dotsFactor * this.leaderPatternWidth));
                    ++idx;
                    break;
                }
                case 124: {
                    MessageHandler.errorln("leader-pattern=\"use-content\" not supported by this version of Fop");
                    return;
                }
            }
        }
    }
}

