/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.EPSImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.JpegImage;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;

public class PDFXObject
extends PDFObject {
    private boolean isPS = false;
    private PDFDocument pdfDoc;
    private PDFICCStream pdfICCStream;
    FopImage fopimage;
    int Xnum;

    public PDFXObject(int number, int Xnumber, FopImage img) {
        this(number, Xnumber, img, null);
    }

    public PDFXObject(int number, int Xnumber, FopImage img, PDFDocument pdfdoc) {
        super(number);
        this.Xnum = Xnumber;
        if (img == null) {
            MessageHandler.errorln("FISH");
        }
        this.fopimage = img;
        this.pdfDoc = pdfdoc;
        this.pdfICCStream = null;
        try {
            if (this.fopimage instanceof JpegImage) {
                this.fopimage.getBitmaps();
                JpegImage jpegimage = (JpegImage)this.fopimage;
                if (jpegimage.getColorSpace().hasICCProfile()) {
                    this.pdfICCStream = this.pdfDoc.makePDFICCStream();
                    this.pdfICCStream.setColorSpace(jpegimage.getColorSpace());
                    this.pdfICCStream.addDefaultFilters();
                }
            }
        }
        catch (Exception e) {
            MessageHandler.errorln("Error while reading image " + this.fopimage.getURL() + ": " + e.getMessage());
        }
    }

    public int getXNumber() {
        return this.Xnum;
    }

    protected int output(OutputStream stream) throws IOException {
        int length;
        block21: {
            length = 0;
            boolean i = false;
            try {
                byte[] pdfBytes;
                if (this.fopimage instanceof EPSImage) {
                    byte[] pdfBytes2;
                    byte[] postBytes;
                    byte[] preBytes;
                    this.isPS = true;
                    EPSImage epsImage = (EPSImage)this.fopimage;
                    int[] bbox = epsImage.getBBox();
                    int bboxw = bbox[2] - bbox[0];
                    int bboxh = bbox[3] - bbox[1];
                    PDFStream imgStream = new PDFStream(0);
                    StringBuffer preamble = new StringBuffer();
                    preamble.append("%%BeginDocument: " + epsImage.getDocName() + "\n");
                    preamble.append("userdict begin                 % Push userdict on dict stack\n");
                    preamble.append("/PreEPS_state save def\n");
                    preamble.append("/dict_stack countdictstack def\n");
                    preamble.append("/ops_count count 1 sub def\n");
                    preamble.append("/showpage {} def\n");
                    preamble.append(String.valueOf(1.0 / (double)bboxw) + " " + 1.0 / (double)bboxh + " scale\n");
                    preamble.append(String.valueOf(-bbox[0]) + " " + -bbox[1] + " translate\n");
                    preamble.append(String.valueOf(bbox[0]) + " " + bbox[1] + " " + bboxw + " " + bboxh + " rectclip\n");
                    preamble.append("newpath\n");
                    StringBuffer post = new StringBuffer();
                    post.append("%%EndDocument\n");
                    post.append("count ops_count sub {pop} repeat\n");
                    post.append("countdictstack dict_stack sub {end} repeat\n");
                    post.append("PreEPS_state restore\n");
                    post.append("end % userdict\n");
                    try {
                        preBytes = preamble.toString().getBytes("ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        preBytes = preamble.toString().getBytes();
                    }
                    try {
                        postBytes = post.toString().getBytes("ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        postBytes = post.toString().getBytes();
                    }
                    byte[] imgData = new byte[preBytes.length + postBytes.length + this.fopimage.getBitmaps().length];
                    System.arraycopy(preBytes, 0, imgData, 0, preBytes.length);
                    System.arraycopy(this.fopimage.getBitmaps(), 0, imgData, preBytes.length, this.fopimage.getBitmaps().length);
                    System.arraycopy(postBytes, 0, imgData, preBytes.length + this.fopimage.getBitmaps().length, postBytes.length);
                    imgStream.setData(imgData);
                    imgStream.addDefaultFilters();
                    String dictEntries = imgStream.applyFilters();
                    String p = String.valueOf(this.number) + " " + this.generation + " obj\n";
                    p = String.valueOf(p) + "<</Type /XObject\n";
                    p = String.valueOf(p) + "/Subtype /PS\n";
                    p = String.valueOf(p) + "/Length " + imgStream.getDataLength();
                    p = String.valueOf(p) + dictEntries;
                    p = String.valueOf(p) + ">>\n";
                    try {
                        pdfBytes2 = p.getBytes("ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        pdfBytes2 = p.getBytes();
                    }
                    stream.write(pdfBytes2);
                    length += pdfBytes2.length;
                    length += imgStream.outputStreamData(stream);
                    try {
                        pdfBytes2 = "endobj\n".getBytes("ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        pdfBytes2 = "endobj\n".getBytes();
                    }
                    stream.write(pdfBytes2);
                    length += pdfBytes2.length;
                    break block21;
                }
                PDFStream imgStream = new PDFStream(0);
                imgStream.setData(this.fopimage.getBitmaps());
                if (this.fopimage.getPDFFilter() != null) {
                    imgStream.addFilter(this.fopimage.getPDFFilter());
                } else {
                    imgStream.addDefaultFilters();
                }
                String dictEntries = imgStream.applyFilters();
                String p = String.valueOf(this.number) + " " + this.generation + " obj\n";
                p = String.valueOf(p) + "<</Type /XObject\n";
                p = String.valueOf(p) + "/Subtype /Image\n";
                p = String.valueOf(p) + "/Name /Im" + this.Xnum + "\n";
                p = String.valueOf(p) + "/Length " + imgStream.getDataLength() + "\n";
                p = String.valueOf(p) + "/Width " + this.fopimage.getWidth() + "\n";
                p = String.valueOf(p) + "/Height " + this.fopimage.getHeight() + "\n";
                p = String.valueOf(p) + "/BitsPerComponent " + this.fopimage.getBitsPerPixel() + "\n";
                if (this.pdfICCStream != null) {
                    p = String.valueOf(p) + "/ColorSpace [/ICCBased " + this.pdfICCStream.referencePDF() + "]\n";
                } else {
                    ColorSpace cs = this.fopimage.getColorSpace();
                    p = String.valueOf(p) + "/ColorSpace /" + cs.getColorSpacePDFString() + "\n";
                }
                if (this.fopimage.getColorSpace().getColorSpace() == ColorSpace.DEVICE_CMYK && this.fopimage.invertImage()) {
                    p = String.valueOf(p) + "/Decode [ 1.0 0.0 1.0 0.0 1.0 0.0 1.1 0.0 ]\n";
                }
                if (this.fopimage.isTransparent()) {
                    PDFColor transp = this.fopimage.getTransparentColor();
                    p = String.valueOf(p) + "/Mask [" + transp.red255() + " " + transp.red255() + " " + transp.green255() + " " + transp.green255() + " " + transp.blue255() + " " + transp.blue255() + "]\n";
                }
                p = String.valueOf(p) + dictEntries;
                p = String.valueOf(p) + ">>\n";
                try {
                    pdfBytes = p.getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    pdfBytes = p.getBytes();
                }
                stream.write(pdfBytes);
                length += pdfBytes.length;
                length += imgStream.outputStreamData(stream);
                try {
                    pdfBytes = "endobj\n".getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    pdfBytes = "endobj\n".getBytes();
                }
                stream.write(pdfBytes);
                length += pdfBytes.length;
            }
            catch (FopImageException imgex) {
                MessageHandler.errorln("Error in XObject : " + imgex.getMessage());
            }
        }
        return length;
    }

    byte[] toPDF() {
        return null;
    }
}

