/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.svg.SVGArea;

public abstract class PrintRenderer
extends AbstractRenderer {
    protected String currentFontName;
    protected int currentFontSize;
    protected PDFPathPaint currentStroke = null;
    protected PDFPathPaint currentFill = null;
    protected int prevUnderlineXEndPos;
    protected int prevUnderlineYEndPos;
    protected int prevUnderlineSize;
    protected PDFColor prevUnderlineColor;
    protected int prevOverlineXEndPos;
    protected int prevOverlineYEndPos;
    protected int prevOverlineSize;
    protected PDFColor prevOverlineColor;
    protected int prevLineThroughXEndPos;
    protected int prevLineThroughYEndPos;
    protected int prevLineThroughSize;
    protected PDFColor prevLineThroughColor;
    protected FontInfo fontInfo;
    protected IDReferences idReferences;

    protected void addFilledRect(int x, int y, int w, int h, ColorType col) {
        PDFColor pdfcol = new PDFColor(col);
        this.addRect(x, y, w, h, pdfcol, pdfcol);
    }

    protected void addFilledRect(int x, int y, int w, int h, PDFPathPaint fill) {
        this.addRect(x, y, w, h, fill, fill);
    }

    protected abstract void addLine(int var1, int var2, int var3, int var4, int var5, int var6, PDFPathPaint var7);

    protected abstract void addLine(int var1, int var2, int var3, int var4, int var5, PDFPathPaint var6);

    protected abstract void addRect(int var1, int var2, int var3, int var4, PDFPathPaint var5);

    protected abstract void addRect(int var1, int var2, int var3, int var4, PDFPathPaint var5, PDFPathPaint var6);

    protected void addWordLines(WordArea area, int rx, int bl, int size, PDFColor theAreaColor) {
        int yPos;
        if (area.getUnderlined()) {
            yPos = bl - size / 10;
            this.addLine(rx, yPos, rx + area.getContentWidth(), yPos, size / 14, theAreaColor);
            this.prevUnderlineXEndPos = rx + area.getContentWidth();
            this.prevUnderlineYEndPos = yPos;
            this.prevUnderlineSize = size / 14;
            this.prevUnderlineColor = theAreaColor;
        }
        if (area.getOverlined()) {
            yPos = bl + area.getFontState().getAscender() + size / 10;
            this.addLine(rx, yPos, rx + area.getContentWidth(), yPos, size / 14, theAreaColor);
            this.prevOverlineXEndPos = rx + area.getContentWidth();
            this.prevOverlineYEndPos = yPos;
            this.prevOverlineSize = size / 14;
            this.prevOverlineColor = theAreaColor;
        }
        if (area.getLineThrough()) {
            yPos = bl + area.getFontState().getAscender() * 3 / 8;
            this.addLine(rx, yPos, rx + area.getContentWidth(), yPos, size / 14, theAreaColor);
            this.prevLineThroughXEndPos = rx + area.getContentWidth();
            this.prevLineThroughYEndPos = yPos;
            this.prevLineThroughSize = size / 14;
            this.prevLineThroughColor = theAreaColor;
        }
    }

    protected void doFrame(Area area) {
        int rx = this.currentAreaContainerXPosition;
        int w = area.getContentWidth();
        if (area instanceof BlockArea) {
            rx += ((BlockArea)area).getStartIndent();
        }
        int h = area.getContentHeight();
        int ry = this.currentYPosition;
        w = w + area.getPaddingLeft() + area.getPaddingRight();
        h = h + area.getPaddingTop() + area.getPaddingBottom();
        this.doBackground(area, rx -= area.getPaddingLeft(), ry += area.getPaddingTop(), w, h);
        BorderAndPadding bp = area.getBorderAndPadding();
        int left = area.getBorderLeftWidth();
        int right = area.getBorderRightWidth();
        int top = area.getBorderTopWidth();
        int bottom = area.getBorderBottomWidth();
        if (top != 0) {
            this.addFilledRect(rx, ry, w, top, new PDFColor(bp.getBorderColor(0)));
        }
        if (left != 0) {
            this.addFilledRect(rx - left, ry - h - bottom, left, h + top + bottom, new PDFColor(bp.getBorderColor(3)));
        }
        if (right != 0) {
            this.addFilledRect(rx + w, ry - h - bottom, right, h + top + bottom, new PDFColor(bp.getBorderColor(1)));
        }
        if (bottom != 0) {
            this.addFilledRect(rx, ry - h - bottom, w, bottom, new PDFColor(bp.getBorderColor(2)));
        }
    }

    public void renderDisplaySpace(DisplaySpace space) {
        int d = space.getSize();
        this.currentYPosition -= d;
    }

    public abstract void renderForeignObjectArea(ForeignObjectArea var1);

    public void renderInlineSpace(InlineSpace space) {
        this.currentXPosition += space.getSize();
        if (space.getUnderlined() && this.prevUnderlineColor != null) {
            this.addLine(this.prevUnderlineXEndPos, this.prevUnderlineYEndPos, this.prevUnderlineXEndPos + space.getSize(), this.prevUnderlineYEndPos, this.prevUnderlineSize, this.prevUnderlineColor);
            this.prevUnderlineXEndPos += space.getSize();
        }
        if (space.getOverlined() && this.prevOverlineColor != null) {
            this.addLine(this.prevOverlineXEndPos, this.prevOverlineYEndPos, this.prevOverlineXEndPos + space.getSize(), this.prevOverlineYEndPos, this.prevOverlineSize, this.prevOverlineColor);
            this.prevOverlineXEndPos += space.getSize();
        }
        if (space.getLineThrough() && this.prevLineThroughColor != null) {
            this.addLine(this.prevLineThroughXEndPos, this.prevLineThroughYEndPos, this.prevLineThroughXEndPos + space.getSize(), this.prevLineThroughYEndPos, this.prevLineThroughSize, this.prevLineThroughColor);
            this.prevLineThroughXEndPos += space.getSize();
        }
    }

    public void renderLeaderArea(LeaderArea area) {
        int rx = this.currentXPosition;
        int ry = this.currentYPosition;
        int w = area.getContentWidth();
        int h = area.getHeight();
        int th = area.getRuleThickness();
        int st = area.getRuleStyle();
        if (th != 0) {
            switch (st) {
                case 28: {
                    this.addLine(rx, ry, rx + w, ry, th / 3, st, new PDFColor(area.getRed(), area.getGreen(), area.getBlue()));
                    this.addLine(rx, ry + 2 * th / 3, rx + w, ry + 2 * th / 3, th / 3, st, new PDFColor(area.getRed(), area.getGreen(), area.getBlue()));
                    break;
                }
                case 43: {
                    this.addLine(rx, ry, rx + w, ry, th / 2, st, new PDFColor(area.getRed(), area.getGreen(), area.getBlue()));
                    this.addLine(rx, ry + th / 2, rx + w, ry + th / 2, th / 2, st, new PDFColor(255, 255, 255));
                    break;
                }
                case 96: {
                    this.addLine(rx, ry, rx + w, ry, th / 2, st, new PDFColor(255, 255, 255));
                    this.addLine(rx, ry + th / 2, rx + w, ry + th / 2, th / 2, st, new PDFColor(area.getRed(), area.getGreen(), area.getBlue()));
                    break;
                }
                default: {
                    this.addLine(rx, ry, rx + w, ry, th, st, new PDFColor(area.getRed(), area.getGreen(), area.getBlue()));
                }
            }
            this.currentXPosition += area.getContentWidth();
            this.currentYPosition += th;
        }
    }

    public abstract void renderPage(Page var1);

    public abstract void renderSVGArea(SVGArea var1);

    public abstract void renderWordArea(WordArea var1);

    public abstract void setProducer(String var1);

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        this.fontInfo = fontInfo;
        FontSetup.setup(fontInfo);
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.idReferences = null;
        this.currentFontName = "";
        this.currentStroke = null;
        this.currentFill = null;
        this.prevUnderlineColor = null;
        this.prevOverlineColor = null;
        this.prevLineThroughColor = null;
        this.fontInfo = null;
        this.idReferences = null;
    }
}

