/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.pcl.PCLStream;
import org.apache.fop.svg.SVGArea;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PCLRenderer
extends PrintRenderer {
    public PCLStream currentStream;
    private int pageHeight = 7920;
    public int curdiv = 0;
    private int divisions = -1;
    public int paperheight = -1;
    public int orientation = 0;
    public int topmargin = -1;
    public int leftmargin = -1;
    private int fullmargin = 0;
    private final boolean debug = false;
    private int xoffset = -180;
    private Map options;

    protected void addLine(int x1, int y1, int x2, int y2, int th, int rs, PDFPathPaint stroke) {
        int dashon = 0;
        int dashoff = 0;
        switch (rs) {
            case 22: {
                dashon = 3;
                dashoff = 3;
                break;
            }
            case 27: {
                dashon = 1;
                dashoff = 3;
                break;
            }
        }
        if (x1 == x2) {
            if (dashon > 0 && dashoff > 0) {
                int start = y1;
                int len = th * dashon;
                while (start < y2) {
                    if (start + len > y2) {
                        len = y2 - start;
                    }
                    this.addRect(x1 - th / 2, start, th, len, stroke, stroke);
                    start += len + dashoff * th;
                }
            } else {
                this.addRect(x1 - th / 2, y1, th, y2 - y1 + 1, stroke, stroke);
            }
        } else if (y1 == y2) {
            if (dashon > 0 && dashoff > 0) {
                int start = x1;
                int len = th * dashon;
                while (start < x2) {
                    if (start + len > x2) {
                        len = x2 - start;
                    }
                    this.addRect(start, y1 + th / 2, len, th, stroke, stroke);
                    start += len + dashoff * th;
                }
            } else {
                this.addRect(x1, y1 + th / 2, x2 - x1 + 1, th, stroke, stroke);
            }
        }
    }

    protected void addLine(int x1, int y1, int x2, int y2, int th, PDFPathPaint stroke) {
        if (x1 == x2) {
            this.addRect(x1 - th / 2, y1, th, y2 - y1 + 1, stroke, stroke);
        } else if (y1 == y2) {
            this.addRect(x1, y1 + th / 2, x2 - x1 + 1, th, stroke, stroke);
        }
    }

    protected void addRect(int x, int y, int w, int h, PDFPathPaint stroke) {
        if (h >= 0 && h < 720 || h < 0 && h > -720 || w < 720) {
            if (w < 720) {
                w = 720;
            }
            if (h > 0 && h < 720) {
                h = 720;
            } else if (h < 0 && h > -720) {
                h = -720;
            }
            this.addRect(x, y, w, h, stroke, stroke);
        } else {
            this.addRect(x, y, w, 720, stroke, stroke);
            this.addRect(x, y, 720, h, stroke, stroke);
            this.addRect(x + w - 720, y, 720, h, stroke, stroke);
            this.addRect(x, y - h + 720, w, 720, stroke, stroke);
        }
    }

    protected void addRect(int x, int y, int w, int h, PDFPathPaint stroke, PDFPathPaint fill) {
        if (w == 0 || h == 0) {
            return;
        }
        if (h < 0) {
            h *= -1;
        } else {
            y += h;
        }
        PDFColor sc = (PDFColor)stroke;
        PDFColor fc = (PDFColor)fill;
        sc.setColorSpace(ColorSpace.DEVICE_RGB);
        fc.setColorSpace(ColorSpace.DEVICE_RGB);
        int lineshade = (int)(100.0 - ((double)0.3f * sc.red() + (double)0.59f * sc.green() + (double)0.11f * sc.blue()) * 100.0);
        int fillshade = (int)(100.0 - ((double)0.3f * fc.red() + (double)0.59f * fc.green() + (double)0.11f * fc.blue()) * 100.0);
        int xpos = this.xoffset + x / 100;
        if (xpos < 0) {
            xpos = 0;
            this.log.warn("Horizontal position out of bounds.");
        }
        this.currentStream.add("\u001b*v1O\u001b&a" + xpos + "h" + (this.pageHeight - y / 100) + "V" + "\u001b*c" + w / 100 + "h" + h / 100 + "V" + "\u001b*c" + lineshade + "G" + "\u001b*c2P");
        if (fillshade != lineshade && (w >= 720 || h >= 720)) {
            xpos = this.xoffset + (x + 240) / 100;
            if (xpos < 0) {
                xpos = 0;
                this.log.warn("Horizontal position out of bounds.");
            }
            this.currentStream.add("\u001b&a" + xpos + "h" + (this.pageHeight - (y + 240) / 100) + "V" + "\u001b*c" + (w - 480) / 100 + "h" + (h - 480) / 100 + "V" + "\u001b*c" + fillshade + "G" + "\u001b*c2P");
        }
        this.currentStream.add("\u001b*v0O");
    }

    protected void drawImageClipped(int x, int y, int clipX, int clipY, int clipW, int clipH, FopImage image, FontState fs) {
    }

    protected void drawImageScaled(int x, int y, int w, int h, FopImage image, FontState fs) {
    }

    boolean printBMP(FopImage img, int x, int y, int w, int h) throws FopImageException {
        byte[] imgmap = img.getBitmaps();
        int ix = 0;
        int iy = 0;
        int indx = 0;
        int iw = img.getWidth();
        int ih = img.getHeight();
        int bytewidth = iw / 8;
        if (iw % 8 != 0) {
            ++bytewidth;
        }
        char[] ic = new char[bytewidth * 2];
        char[] icu = new char[bytewidth];
        int lastcount = -1;
        int lastbyte = 0;
        int icwidth = 0;
        int cr = 0;
        int cg = 0;
        int cb = 0;
        int grey = 0;
        boolean iscolor = img.getColorSpace().getColorSpace() != ColorSpace.DEVICE_GRAY;
        boolean dcount = false;
        int xres = iw * 72000 / w;
        int yres = ih * 72000 / h;
        int resolution = xres;
        if (yres > xres) {
            resolution = yres;
        }
        resolution = resolution > 300 ? 600 : (resolution > 150 ? 300 : (resolution > 100 ? 150 : (resolution > 75 ? 100 : 75)));
        this.currentStream.add("\u001b*t" + resolution + "R\u001b*r0F\u001b*r1A");
        iy = 0;
        while (iy < ih) {
            int ib = 0;
            indx = iy * iw;
            if (iscolor) {
                indx *= 3;
            }
            ix = 0;
            while (ix < iw) {
                if (iscolor) {
                    cr = imgmap[indx++] & 0xFF;
                    cg = imgmap[indx++] & 0xFF;
                    cb = imgmap[indx++] & 0xFF;
                    grey = (cr * 30 + cg * 59 + cb * 11) / 100;
                } else {
                    grey = imgmap[indx++] & 0xFF;
                }
                if (grey < 128) {
                    ib = (byte)(ib | 1 << 7 - ix % 8);
                }
                if (ix % 8 == 7 || ix + 1 == iw) {
                    if (icwidth < bytewidth) {
                        if (lastcount >= 0) {
                            if (ib == lastbyte) {
                                ++lastcount;
                            } else {
                                ic[icwidth++] = (char)(lastcount & 0xFF);
                                ic[icwidth++] = (char)lastbyte;
                                lastbyte = ib;
                                lastcount = 0;
                            }
                        } else {
                            lastbyte = ib;
                            lastcount = 0;
                        }
                        if (lastcount == 255 || ix + 1 == iw) {
                            ic[icwidth++] = (char)(lastcount & 0xFF);
                            ic[icwidth++] = (char)lastbyte;
                            lastbyte = 0;
                            lastcount = -1;
                        }
                    }
                    icu[ix / 8] = (char)ib;
                    ib = 0;
                }
                ++ix;
            }
            if (icwidth < bytewidth) {
                this.currentStream.add("\u001b*b1m" + icwidth + "W");
                this.currentStream.add(new String(ic, 0, icwidth));
            } else {
                this.currentStream.add("\u001b*b0m" + bytewidth + "W");
                this.currentStream.add(new String(icu));
            }
            lastcount = -1;
            icwidth = 0;
            ++iy;
        }
        this.currentStream.add("\u001b*rB");
        return true;
    }

    public void render(Page page, OutputStream outputStream) throws IOException {
        this.idReferences = page.getIDReferences();
        this.renderPage(page);
    }

    public void renderForeignObjectArea(ForeignObjectArea area) {
        this.currentXPosition += area.getXOffset();
        this.currentYPosition = this.currentYPosition;
        switch (area.getAlign()) {
            default: 
        }
        switch (area.getVerticalAlign()) {
            default: 
        }
        switch (area.scalingMethod()) {
            default: 
        }
        switch (area.getOverflow()) {
            default: 
        }
        area.getObject().render(this);
        this.currentXPosition += area.getEffectiveWidth();
    }

    public void renderImageArea(ImageArea area) {
        int x = this.currentAreaContainerXPosition + area.getXOffset();
        int y = this.currentYPosition;
        int w = area.getContentWidth();
        int h = area.getHeight();
        this.currentYPosition -= h;
        FopImage img = area.getImage();
        int xpos = this.xoffset + x / 100;
        if (xpos < 0) {
            xpos = 0;
            this.log.warn("Horizontal position out of bounds.");
        }
        this.currentStream.add("\u001b&a" + xpos + "h" + (this.pageHeight - y / 100) + "V");
        try {
            this.printBMP(img, x, y, w, h);
        }
        catch (FopImageException e) {
            this.log.error("PCLRenderer.renderImageArea() Error printing BMP (" + e.toString() + ")");
        }
    }

    public void renderPage(Page page) {
        if (page.getHeight() < page.getWidth()) {
            this.orientation = 1;
        }
        this.currentStream.add("\u001b&l" + this.orientation + "O");
        this.xoffset = this.orientation == 1 || this.orientation == 3 ? -144 : -180;
        if (this.paperheight > 0 && this.divisions == -1) {
            this.divisions = this.paperheight / (page.getHeight() / 100);
        }
        if (this.divisions > 0) {
            this.fullmargin = this.paperheight * this.curdiv / this.divisions;
        }
        if (this.topmargin > 0) {
            this.fullmargin += this.topmargin;
        }
        this.pageHeight = this.paperheight > 0 ? this.paperheight / this.divisions + this.fullmargin : page.getHeight() / 100;
        if (this.leftmargin > 0 && this.curdiv == 0) {
            this.currentStream.add("\u001b&k" + (float)this.leftmargin / 6.0f + "H\u001b&a1L\u001b&k12H");
        }
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.renderRegions(page);
        if (++this.curdiv == this.divisions || this.divisions == -1) {
            this.curdiv = 0;
            this.currentStream.add("\f");
        }
    }

    public void renderSVGArea(SVGArea area) {
        int x = this.currentXPosition;
        int y = this.currentYPosition;
        SVGSVGElement svg = ((SVGDocument)area.getSVGDocument()).getRootElement();
        int w = (int)(svg.getWidth().getBaseVal().getValue() * 1000.0f);
        int h = (int)(svg.getHeight().getBaseVal().getValue() * 1000.0f);
    }

    public void renderWordArea(WordArea area) {
        String s;
        String name = area.getFontState().getFontName();
        int size = area.getFontState().getFontSize();
        float red = area.getRed();
        float green = area.getGreen();
        float blue = area.getBlue();
        PDFColor theAreaColor = new PDFColor(area.getRed(), area.getGreen(), area.getBlue());
        this.currentStream.add("\u001b*v1O\u001b*c" + (int)(100.0f - (0.3f * red + 0.59f * green + 0.11f * blue) * 100.0f) + "G\u001b*v2T");
        if (!name.equals(this.currentFontName) || size != this.currentFontSize) {
            this.currentFontName = name;
            this.currentFontSize = size;
            this.setFont(name, size);
        }
        this.currentFill = theAreaColor;
        int rx = this.currentXPosition;
        int bl = this.currentYPosition;
        if (area.getPageNumberID() != null) {
            s = this.idReferences.getPageNumber(area.getPageNumberID());
            if (s == null) {
                s = "";
            }
        } else {
            s = area.getText();
        }
        this.addWordLines(area, rx, bl, size, theAreaColor);
        int xpos = this.xoffset + rx / 100;
        if (xpos < 0) {
            xpos = 0;
            this.log.warn("Horizontal position out of bounds.");
        }
        this.currentStream.add("\u001b&a" + xpos + "h" + (this.pageHeight - bl / 100) + "V" + s);
        this.currentXPosition += area.getContentWidth();
    }

    public void setFont(String name, float size) {
        int fontcode = 0;
        if (name.length() > 1 && name.charAt(0) == 'F') {
            try {
                fontcode = Integer.parseInt(name.substring(1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        switch (fontcode) {
            case 1: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v0s0b16602T");
                break;
            }
            case 2: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v1s0b16602T");
                break;
            }
            case 3: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v0s3b16602T");
                break;
            }
            case 4: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v1s3b16602T");
                break;
            }
            case 5: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v0s0b16901T");
                break;
            }
            case 6: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v1s0b16901T");
                break;
            }
            case 7: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v0s3b16901T");
                break;
            }
            case 8: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v1s3b16901T");
                break;
            }
            case 9: {
                this.currentStream.add("\u001b(0N\u001b(s0p" + 120.01f / (size / 1000.0f) + "h0s0b4099T");
                break;
            }
            case 10: {
                this.currentStream.add("\u001b(0N\u001b(s0p" + 120.01f / (size / 1000.0f) + "h1s0b4099T");
                break;
            }
            case 11: {
                this.currentStream.add("\u001b(0N\u001b(s0p" + 120.01f / (size / 1000.0f) + "h0s3b4099T");
                break;
            }
            case 12: {
                this.currentStream.add("\u001b(0N\u001b(s0p" + 120.01f / (size / 1000.0f) + "h1s3b4099T");
                break;
            }
            case 13: {
                this.currentStream.add("\u001b(19M\u001b(s1p" + size / 1000.0f + "v0s0b16686T");
                break;
            }
            case 14: {
                this.currentStream.add("\u001b(14L\u001b(s1p" + size / 1000.0f + "v0s0b45101T");
                break;
            }
            default: {
                this.currentStream.add("\u001b(0N\u001b(s" + size / 1000.0f + "V");
            }
        }
    }

    public void setOptions(Map options) {
        this.options = options;
    }

    public void setProducer(String producer) {
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.log.info("rendering areas to PCL");
        this.currentStream = new PCLStream(outputStream);
        this.currentStream.add("\u001b9\u001b&l0E");
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.log.info("writing out PCL");
        outputStream.flush();
    }
}

