xquery version "1.0" encoding "UTF-8";
(: $Id: fpml-cd.xq 4763 2008-09-15 10:28:42Z matthew $ :)

module namespace cd="http://www.fpml.org/2009/FpML-4-6/cd";

declare default element namespace "http://www.fpml.org/2009/FpML-4-6";
import schema namespace fpml="http://www.fpml.org/2009/FpML-4-6" at "../../schema/fpml-main.xsd"; 
import schema namespace val="http://www.fpml.org/2009/FpML-4-6/validation" at "Validation.xsd";

import module namespace res="http://www.fpml.org/2009/FpML-4-6/results" at "fpml-results.xq";
import module namespace fun="http://www.fpml.org/2009/FpML-4-6/functions" at "fpml-functions.xq";

declare variable $cd:evaluation as document-node(element(val:documentEvaluation)) := validate strict{
	document {
		element val:documentEvaluation {

(for $trade as element(*, Trade) in //element(*, Trade)[$fun:singleNamePreCondition][exists(creditDefaultSwap)]
return res:pretty-result(xs:NMTOKEN("cd-1"), $trade/tradeHeader/tradeDate lt $trade/creditDefaultSwap/generalTerms/effectiveDate/unadjustedDate, $trade, ("See issue: http://www.fpml.org/issues/view.php?id=616"))) 
, 
(for $trade as element(*, Trade) in //element(*, Trade)[$fun:creditIndexPreCondition][exists(creditDefaultSwap/generalTerms/effectiveDate)]
return res:pretty-result(xs:NMTOKEN("cd-1b"), $trade/tradeHeader/tradeDate ge $trade/creditDefaultSwap/generalTerms/effectiveDate/unadjustedDate, $trade, ("http://www.fpml.org/issues/view.php?id=708"))) 
, 
(for $trade as element(*, Trade) in //element(*, Trade)
return res:pretty-result(xs:NMTOKEN("cd-2"),  every $calculationAgent in $trade/calculationAgent satisfies (($calculationAgent/calculationAgentParty = "AsSpecifiedInMasterAgreement") or $calculationAgent/calculationAgentPartyReference), $trade, ())) 
,  
(for $contractualTermsSupplement as element(*, ContractualTermsSupplement) in //element(*, ContractualTermsSupplement)[$fun:iSDA1999PreCondition]
return res:pretty-result(xs:NMTOKEN("cd-3b"), xs:boolean(not(starts-with($contractualTermsSupplement/type, "ISDA2003Credit"))), $contractualTermsSupplement, "See issue: http://www.fpml.org/issues/view.php?id=709, http://www.fpml.org/issues/view.php?id=710")) 
, 
(for $trade as element(*, Trade) in //element(*, Trade)[$fun:iSDA2003PreCondition]
return res:pretty-result(xs:NMTOKEN("cd-4b"), every $contractualSupplement in $trade/documentation/contractualSupplement satisfies not(starts-with($contractualSupplement, "ISDA1999Credit")), $trade, ())) 
,
(for $generalTerms as element(*, GeneralTerms) in //element(*, GeneralTerms)[exists(effectiveDate)][exists(scheduledTerminationDate)]
return res:pretty-result(xs:NMTOKEN("cd-5"), $generalTerms/effectiveDate/unadjustedDate lt $generalTerms/scheduledTerminationDate/adjustableDate/unadjustedDate, $generalTerms, ())) 
,
(for $generalTerms as element(*, GeneralTerms) in //element(*, GeneralTerms)
return res:pretty-result(xs:NMTOKEN("cd-6"), $generalTerms/buyerPartyReference/@href ne $generalTerms/sellerPartyReference/@href, $generalTerms, ())) 
,
(for $generalTerms as element(*, GeneralTerms) in //element(*, GeneralTerms)[$fun:longFormPreCondition]
return res:pretty-result(xs:NMTOKEN("cd-7"), exists($generalTerms/effectiveDate/dateAdjustments) or exists($generalTerms/effectiveDate/dateAdjustmentsReference), $generalTerms, ())) 
,
(for $generalTerms as element(*, GeneralTerms) in //element(*, GeneralTerms)[$fun:longFormPreCondition]
return res:pretty-result(xs:NMTOKEN("cd-8"), exists($generalTerms/effectiveDate/dateAdjustments) or exists($generalTerms/effectiveDate/dateAdjustmentsReference), $generalTerms, ())) 
,
(for $generalTerms as element(*, GeneralTerms) in //element(*, GeneralTerms)
return res:pretty-result(xs:NMTOKEN("cd-40"), if (not(exists($generalTerms/indexReferenceInformation/tranche))) then not(exists($generalTerms/modifiedEquityDelivery)) else true(), $generalTerms, ())) 
,
(for $generalTerms as element(*, GeneralTerms) in //element(*, GeneralTerms)
return res:pretty-result(xs:NMTOKEN("cd-42"), if (not(exists($generalTerms/basketReferenceInformation))) then not(exists($generalTerms/substitution)) else true(), $generalTerms, ())) 
,
(for $referenceInformation as element(*, ReferenceInformation) in //element(*, ReferenceInformation)
return res:pretty-result(xs:NMTOKEN("cd-9"), if (exists($referenceInformation/referenceObligation/primaryObligorReference)) then (every $referenceObligation in $referenceInformation/referenceObligation satisfies $referenceObligation/primaryObligorReference/@href eq $referenceInformation/referenceEntity/@id) else true(), $referenceInformation, ())) 
,
(for $referenceInformation as element(*, ReferenceInformation) in //element(*, ReferenceInformation)
return res:pretty-result(xs:NMTOKEN("cd-10"), if (exists($referenceInformation/referenceObligation/guarantorReference)) then ($referenceInformation/referenceObligation/guarantorReference/@href eq $referenceInformation/referenceEntity/@id) else true(), $referenceInformation, ())) 
,
(for $referenceInformation as element(*, ReferenceInformation) in //element(*, ReferenceInformation)[$fun:longFormPreCondition][$fun:iSDA2003PreCondition]
return res:pretty-result(xs:NMTOKEN("cd-11"), exists($referenceInformation/allGuarantees), $referenceInformation, ())) 
,
(for $referenceInformation as element(*, ReferenceInformation) in //element(*, ReferenceInformation)
return res:pretty-result(xs:NMTOKEN("cd-12"), if (exists($referenceInformation/referencePrice)) then ($referenceInformation/referencePrice ge 0) else true(), $referenceInformation, ())) 
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)
return res:pretty-result(xs:NMTOKEN("cd-13"), if (exists($creditDefaultSwap/protectionTerms/creditEvents/creditEventNotice/notifyingParty/buyerPartyReference)) then ($creditDefaultSwap/protectionTerms/creditEvents/creditEventNotice/notifyingParty/buyerPartyReference/@href eq $creditDefaultSwap/generalTerms/buyerPartyReference/@href) else true(), $creditDefaultSwap, ())) 
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)
return res:pretty-result(xs:NMTOKEN("cd-14"), if (exists($creditDefaultSwap/protectionTerms/creditEvents/creditEventNotice/notifyingParty/sellerPartyReference)) then ($creditDefaultSwap/protectionTerms/creditEvents/creditEventNotice/notifyingParty/sellerPartyReference/@href eq $creditDefaultSwap/generalTerms/sellerPartyReference/@href) else true(), $creditDefaultSwap, ())) 
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)
return res:pretty-result(xs:NMTOKEN("cd-15"), if ((count($creditDefaultSwap/generalTerms/referenceInformation/referenceObligation) eq 1) and exists($creditDefaultSwap/cashSettlementTerms/valuationDate/singleValuationDate)) then $creditDefaultSwap/cashSettlementTerms/valuationMethod = ("Market", "Highest") else true(), $creditDefaultSwap, ())) 
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)
return res:pretty-result(xs:NMTOKEN("cd-16"), if ((count($creditDefaultSwap/generalTerms/referenceInformation/referenceObligation) eq 1) and exists($creditDefaultSwap/cashSettlementTerms/valuationDate/multipleValuationDates)) then $creditDefaultSwap/cashSettlementTerms/valuationMethod = ("AverageMarket", "Highest", "AverageHighestMarket") else true(), $creditDefaultSwap, ())) 
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)
return res:pretty-result(xs:NMTOKEN("cd-17"), if ((count($creditDefaultSwap/generalTerms/referenceInformation/referenceObligation) gt 1) and exists($creditDefaultSwap/cashSettlementTerms/valuationDate/singleValuationDate)) then $creditDefaultSwap/cashSettlementTerms/valuationMethod = ("BlendedMarket", "BlendedHighest") else true(), $creditDefaultSwap, ())) 
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)
return res:pretty-result(xs:NMTOKEN("cd-18"), if ((count($creditDefaultSwap/generalTerms/referenceInformation/referenceObligation) gt 1) and exists($creditDefaultSwap/cashSettlementTerms/valuationDate/multipleValuationDates)) then $creditDefaultSwap/cashSettlementTerms/valuationMethod = ("AverageBlendedMarket", "AverageBlendedHighest") else true(), $creditDefaultSwap, ())) 
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)[$fun:iSDA1999PreCondition]
return res:pretty-result(xs:NMTOKEN("cd-19"), not(exists($creditDefaultSwap/protectionTerms/creditEvents/creditEventNotice/businessCenter) or exists($creditDefaultSwap/protectionTerms/creditEvents/restructuring/multipleHolderObligation) or exists($creditDefaultSwap/protectionTerms/creditEvents/restructuring/multipleCreditEventNotices) or exists($creditDefaultSwap/generalTerms/referenceInformation/allGuarantees) or exists($creditDefaultSwap/generalTerms/indexReferenceInformation) or exists($creditDefaultSwap/generalTerms/substitution) or exists($creditDefaultSwap/generalTerms/modifiedEquityDelivery)), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)[$fun:iSDA2003PreCondition]
return res:pretty-result(xs:NMTOKEN("cd-20"), not(exists($creditDefaultSwap/protectionTerms/obligations/notContingent)), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)[$fun:shortFormPreCondition][$fun:singleNamePreCondition]
return res:pretty-result(xs:NMTOKEN("cd-21"), not(exists($creditDefaultSwap/cashSettlementTerms) 
	or exists($creditDefaultSwap/physicalSettlementTerms) 
	or exists($creditDefaultSwap/feeLeg/periodicPayment/fixedAmountCalculation/calculationAmount) 
	or exists($creditDefaultSwap/feeLeg/periodicPayment/fixedAmountCalculation/dayCountFraction) 
	or exists($creditDefaultSwap/protectionTerms/obligations) 
	or exists($creditDefaultSwap/generalTerms/referenceInformation/allGuarantees) 
	or exists($creditDefaultSwap/generalTerms/referenceInformation/referencePrice) 
	or exists($creditDefaultSwap/generalTerms/effectiveDate/dateAdjustments) 
	or exists($creditDefaultSwap/generalTerms/effectiveDate/dateAdjustmentsReference) 
	or exists($creditDefaultSwap/generalTerms/scheduledTerminationDate/adjustableDate/dateAdjustments) 
	or exists($creditDefaultSwap/generalTerms/scheduledTerminationDate/adjustableDate/dateAdjustmentsReference) 
	or exists($creditDefaultSwap/generalTerms/dateAdjustments)), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)[$fun:shortFormPreCondition][$fun:creditIndexPreCondition]
return res:pretty-result(xs:NMTOKEN("cd-21b"), not(exists($creditDefaultSwap/cashSettlementTerms) 
	or exists($creditDefaultSwap/physicalSettlementTerms) 
	or exists($creditDefaultSwap/feeLeg/periodicPayment/fixedAmountCalculation/calculationAmount) 
	or exists($creditDefaultSwap/feeLeg/periodicPayment/fixedAmountCalculation/dayCountFraction) 
	or exists($creditDefaultSwap/protectionTerms/obligations) 
	or exists($creditDefaultSwap/generalTerms/effectiveDate/dateAdjustments) 
	or exists($creditDefaultSwap/generalTerms/effectiveDate/dateAdjustmentsReference) 
	or exists($creditDefaultSwap/generalTerms/scheduledTerminationDate/adjustableDate/dateAdjustments) 
	or exists($creditDefaultSwap/generalTerms/scheduledTerminationDate/adjustableDate/dateAdjustmentsReference) 
	or exists($creditDefaultSwap/generalTerms/dateAdjustments) 
	or exists($creditDefaultSwap/protectionTerms/creditEvents)), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)[$fun:shortFormPreCondition]
return res:pretty-result(xs:NMTOKEN("cd-22"), not(exists($creditDefaultSwap/protectionTerms/creditEvents/bankruptcy) 
	or exists($creditDefaultSwap/protectionTerms/creditEvents/failureToPay) 
	or exists($creditDefaultSwap/protectionTerms/creditEvents/repudiationMoratorium) 
	or exists($creditDefaultSwap/protectionTerms/creditEvents/obligationDefault) 
	or exists($creditDefaultSwap/protectionTerms/creditEvents/obligationAcceleration)), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)[$fun:longFormPreCondition]
return res:pretty-result(xs:NMTOKEN("cd-23"), exists($creditDefaultSwap/cashSettlementTerms) or exists($creditDefaultSwap/physicalSettlementTerms), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)[$fun:longFormPreCondition]
return res:pretty-result(xs:NMTOKEN("cd-24"), exists($creditDefaultSwap/protectionTerms/creditEvents) and exists($creditDefaultSwap/protectionTerms/creditEvents/creditEventNotice) and exists($creditDefaultSwap/protectionTerms/obligations) and exists($creditDefaultSwap/generalTerms/referenceInformation/referencePrice), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)[$fun:longFormPreCondition]
return res:pretty-result(xs:NMTOKEN("cd-25"), if (exists($creditDefaultSwap/physicalSettlementTerms)) then (exists($creditDefaultSwap/physicalSettlementTerms/settlementCurrency) and exists($creditDefaultSwap/physicalSettlementTerms/physicalSettlementPeriod) and exists($creditDefaultSwap/physicalSettlementTerms/escrow) and exists($creditDefaultSwap/physicalSettlementTerms/deliverableObligations/accruedInterest)) else true(), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)
return res:pretty-result(xs:NMTOKEN("cd-26"), if (exists($creditDefaultSwap/feeLeg/singlePayment/adjustablePaymentDate)) then ($creditDefaultSwap/feeLeg/singlePayment/adjustablePaymentDate gt $creditDefaultSwap/generalTerms/effectiveDate/unadjustedDate) else true(), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)
return res:pretty-result(xs:NMTOKEN("cd-27"), if (exists($creditDefaultSwap/feeLeg/singlePayment/adjustablePaymentDate) and exists($creditDefaultSwap/generalTerms/scheduledTerminationDate/adjustableDate/unadjustedDate)) then ($creditDefaultSwap/feeLeg/singlePayment/adjustablePaymentDate lt $creditDefaultSwap/generalTerms/scheduledTerminationDate/adjustableDate/unadjustedDate) else true(), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)
return res:pretty-result(xs:NMTOKEN("cd-28"), if (exists($creditDefaultSwap/feeLeg/periodicPayment/firstPaymentDate)) then ($creditDefaultSwap/feeLeg/periodicPayment/firstPaymentDate gt $creditDefaultSwap/generalTerms/effectiveDate/unadjustedDate) else true(), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)
return res:pretty-result(xs:NMTOKEN("cd-29"), if (exists($creditDefaultSwap/feeLeg/periodicPayment/firstPaymentDate) and exists($creditDefaultSwap/generalTerms/scheduledTerminationDate/adjustableDate)) then ($creditDefaultSwap/feeLeg/periodicPayment/firstPaymentDate lt $creditDefaultSwap/generalTerms/scheduledTerminationDate/adjustableDate/unadjustedDate) else true(), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)
return res:pretty-result(xs:NMTOKEN("cd-30"), if (exists($creditDefaultSwap/feeLeg/periodicPayment/lastRegularPaymentDate) and exists($creditDefaultSwap/generalTerms/scheduledTerminationDate/adjustableDate)) then ($creditDefaultSwap/feeLeg/periodicPayment/lastRegularPaymentDate lt $creditDefaultSwap/generalTerms/scheduledTerminationDate/adjustableDate/unadjustedDate) else true(), $creditDefaultSwap, ()))
,
(for $creditDefaultSwap as element(*, CreditDefaultSwap) in //element(*, CreditDefaultSwap)[$fun:singleNamePreCondition]
return res:pretty-result(xs:NMTOKEN("cd-43"), if (exists($creditDefaultSwap/feeLeg/initialPayment)) then (($creditDefaultSwap/feeLeg/initialPayment/payerPartyReference/@href eq 
$creditDefaultSwap/generalTerms/sellerPartyReference/@href) and ($creditDefaultSwap/feeLeg/initialPayment/receiverPartyReference/@href eq $creditDefaultSwap/generalTerms/buyerPartyReference/@href)) else true(), $creditDefaultSwap, ()))
,
(for $periodicPayment as element(*, PeriodicPayment) in //element(*, PeriodicPayment)
return res:pretty-result(xs:NMTOKEN("cd-31"), if (exists($periodicPayment/firstPaymentDate) and exists($periodicPayment/lastRegularPaymentDate)) then ($periodicPayment/firstPaymentDate lt $periodicPayment/lastRegularPaymentDate) else true(), $periodicPayment, ()))
,
(for $periodicPayment as element(*, PeriodicPayment) in //element(*, PeriodicPayment)[$fun:longFormPreCondition]
return res:pretty-result(xs:NMTOKEN("cd-31"), if (exists($periodicPayment/fixedAmountCalculation) and exists($periodicPayment/lastRegularPaymentDate)) then ($periodicPayment/firstPaymentDate lt $periodicPayment/lastRegularPaymentDate) else true(), $periodicPayment, ()))
,
(for $periodicPayment as element(*, PeriodicPayment) in //element(*, PeriodicPayment)[$fun:longFormPreCondition]
return res:pretty-result(xs:NMTOKEN("cd-32"), if (exists($periodicPayment/fixedAmountCalculation)) then (exists($periodicPayment/fixedAmountCalculation/calculationAmount) and exists($periodicPayment/fixedAmountCalculation/dayCountFraction)) else true(), $periodicPayment, ()))
(:
Rule cd-33 is badly broken. See issue: http://www.fpml.org/issues/view.php?id=636
cd-33 (Mandatory)
If both firstPaymentDate and lastRegularPaymentDate are present, then lastRegularPaymentDate must fall precisely on a date reachable by adding an integer multiple of the period in paymentFrequency to firstPaymentDate.
Test cases: [Valid] [Invalid] [Invalid]
:)
,
(for $deliverableObligations as element(*, DeliverableObligations) in //element(*, DeliverableObligations)
return res:pretty-result(xs:NMTOKEN("cd-34"), if ($deliverableObligations/category eq "ReferenceObligationsOnly") then (count($deliverableObligations/element()) = 1) else true(), $deliverableObligations, ()))
,
(for $creditEvents as element(*, CreditEvents) in //element(*, CreditEvents)
return res:pretty-result(xs:NMTOKEN("cd-35"), count($creditEvents/element()) ge 1, $creditEvents, ()))
,
(for $publiclyAvailableInformation as element(*, PubliclyAvailableInformation) in //element(*, PubliclyAvailableInformation)
return res:pretty-result(xs:NMTOKEN("cd-36"), exists($publiclyAvailableInformation/standardPublicSources) or exists($publiclyAvailableInformation/publicSource), $publiclyAvailableInformation, ()))
,
(for $cashSettlementTerms as element(*, CashSettlementTerms) in //element(*, CashSettlementTerms)[$fun:sameCurrencyPreCondition][exists(quotationAmount)][exists(minimumQuotationAmount)]
return res:pretty-result(xs:NMTOKEN("cd-37"), $cashSettlementTerms/quotationAmount/amount ge $cashSettlementTerms/minimumQuotationAmount/amount, $cashSettlementTerms, ()))
,
(for $referencePool as element(*, ReferencePool) in //element(*, ReferencePool)
return res:pretty-result(xs:NMTOKEN("cd-38"), (sum($referencePool/referencePoolItem/constituentWeight/basketPercentage) eq 1) or not(exists($referencePool/referencePoolItem/constituentWeight)), $referencePool, ("See the issue: http://www.fpml.org/issues/view.php?id=644"))) 
,
(for $basketReferenceInformation as element(*, BasketReferenceInformation) in //element(*, BasketReferenceInformation)
return res:pretty-result(xs:NMTOKEN("cd-39"), if (exists($basketReferenceInformation/nthToDefault) and exists($basketReferenceInformation/mthToDefault)) then ($basketReferenceInformation/nthToDefault lt $basketReferenceInformation/mthToDefault) else true(), $basketReferenceInformation, ()))
,
(for $tranche as element(*, Tranche) in //element(*, Tranche)
return res:pretty-result(xs:NMTOKEN("cd-39"), $tranche/attachmentPoint le $tranche/exhaustionPoint, $tranche, ()))
		}	
	}
};